import javax.microedition.midlet.*;
import javax.microedition.rms.*;

public class testRecordListener
       extends MIDlet implements RecordListener {

  RecordStore myDB = null;

  /**
   *  Constructeur
  **/
  public testRecordListener() {
  }

  /**
   *  Lance l'application
  **/
  public void startApp()
         throws MIDletStateChangeException {
    // Variable utilise pour contenir l'enregistrement
    byte myData[] = new byte [4];
    int myID = 0;
    try {
      // Ouvre le Record store myDB
      myDB = RecordStore.openRecordStore ("myDB", true);
      // Ajoute le RecordListener
      myDB.addRecordListener(this);
    } catch (Exception e) {
      System.out.println ("Erreur : " + e.getMessage());
    } finally { }
    try {
      // Rcupre l'ID de l'enregistrement suivant
      myID = myDB.getNextRecordID();
      // Stocke cet ID dans l'enregistrement
      myData [0] = (byte) ((myID >> 24) & 0xff);
      myData [1] = (byte) ((myID >> 16) & 0xff);
      myData [2] = (byte) ((myID >> 8) & 0xff);
      myData [3] = (byte) (myID & 0xff);
      // Ajoute un enregistrement
      System.out.println ("Enregistrement " + myDB.addRecord (myData, 0, 4) + " ajout.");
    } catch (Exception e) {
      System.out.println ("Erreur : " + e.getMessage());
    } finally { }
    try {
      // Modifie l'enregistrement
      myDB.setRecord (myID, myData, 0, 4);
      System.out.println ("Enregistrement " + myID + " modifi.");
    } catch (Exception e) {
      System.out.println ("Erreur : " + e.getMessage());
    } finally { }
    try {
      // Supprime l'enregistrement
      myDB.deleteRecord (myID);
      System.out.println ("Enregistrement " + myID + " supprim.");
    } catch (Exception e) {
      System.out.println ("Erreur : " + e.getMessage());
    } finally { }
    destroyApp (true);
    notifyDestroyed();
  }

  /**
   *  Suspend l'excution du MIDlet
  **/
  public void pauseApp() {
  }

  /**
   *  Libre les ressources
  **/
  public void destroyApp (boolean unconditional) {
    // Ferme le Record store
    try {
      myDB.closeRecordStore();
    } catch (Exception e) {
      System.out.println ("Erreur : " + e.getMessage());
    }
  }

  /**
   *  Implmentation du RecordListener
  **/
  public void recordAdded(RecordStore recordStore, int recordId) {
    System.out.println ("Ajout de l'enregistrement " + recordId + " dtect.");
  }

  public void recordChanged(RecordStore recordStore, int recordId) {
    System.out.println ("Modification de l'enregistrement " + recordId + " dtecte.");
  }

  public void recordDeleted(RecordStore recordStore, int recordId) {
    System.out.println ("Suppression de l'enregistrement " + recordId + " dtecte.");
  }

}
